using System;
using CsGL.OpenGL;

namespace SPStudio
{
	/// <summary>
	/// Holds three Vector3Ds to represent itself
	/// in 3D space. Knows how to 
	/// draw itself in OpenGL.
	/// </summary>
	public class Triangle3D: Renderable
	{
		#region Public Vars
		public Vector3D p1 = new Vector3D();
		public Vector3D p2 = new Vector3D();
		public Vector3D p3 = new Vector3D();
		public double degree = 0.0;
		#endregion

		#region Constructors
		/// <summary>
		/// Standard Constructor that initializes
		/// all variables to their defaults.
		/// </summary>
		public Triangle3D()
		{
		}

		/// <summary>
		/// Constructor copies the x,y,z components
		/// of the input Vector3Ds in order to
		/// generate the Triangle3D, it doesn't
		/// make references to them.
		/// </summary>
		/// <param name="P1"></param>
		/// <param name="P2"></param>
		/// <param name="P3"></param>
		public Triangle3D(Vector3D P1, Vector3D P2, Vector3D P3)
		{
			p1.x = P1.x;
			p1.y = P1.y;
			p1.z = P1.z;

			p2.x = P2.x;
			p2.y = P2.y;
			p2.z = P2.z;

			p3.x = P3.x;
			p3.y = P3.y;
			p3.z = P3.z;
		}
		#endregion

		#region Renderable Members
		/// <summary>
		/// Uses CsGL.OpenGL functionality
		/// in order to render the object.
		/// </summary>
		/// <param name="State"></param>
		public void OpenGLDraw(bool[] State)
		{
			//State is expected to be a bool[8]
			GL.glBegin(GL.GL_TRIANGLES);
			GL.glColor3d(0.0,0.0,1.0);
			GL.glVertex3d(p1.x,p1.y,p1.z);
			GL.glVertex3d(p2.x,p2.y,p2.z);
			GL.glVertex3d(p3.x,p3.y,p3.z);
			GL.glEnd();
		}
		#endregion
	}
}
